--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Ingredients
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local function DoOne(i)
	i.inventory = i.inventory + 100
	i.usetime = gSim.weeks
	gSim:QueueMessage("Debug: "..tostring(i.name))
	gSim:InventoryChanged()
end

local function DoAll()
	for i in LItem:AllIngredients() do
		i.inventory = i.inventory + 100
		i.usetime = gSim.weeks
	end
	gSim:QueueMessage("Debug: All Ingredients")
	gSim:InventoryChanged()
end

local function CloseMenu()
	gSim:FlushMessages()
	CloseWindow()
end

-------------------------------------------------------------------------------

local menu = {}
local x=0
local y=0

table.insert(menu, DevMenuItem { x=x,y=y, w=100, label="#-CLOSE-", command=CloseMenu })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=x,y=y, w=100, label="#-ALL-", command=function() DoAll() CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2

for ing in LItem:AllIngredients() do
	local i = ing
	table.insert(menu, DevMenuItem { x=x,y=y, w=100, label=ing.name, command=function() DoOne(i) gSim:FlushMessages() end })
	y = y + bsgFontHeight(devfont) + 2
	if y > 380 then
		x = x + 100
		y = 0
	end
end
	
-------------------------------------------------------------------------------

x = gDialogTable.x or 0
y = gDialogTable.y or 0

MakeDialog
{
	Rectangle
	{
		x=x,y=y, color=devBackgroundColor, alpha=devAlpha, inset=3,
		Group(menu),
	}
}
